/*************************************************************************
 *
 * Copyright (c) 2001-2002 by AlphaSmart, Inc.
 * All rights reserved.
 *
 * FILE:            USBEmu.h
 *
 * DESCRIPTION: USB Keyboard Emulator and Text Transfer program public 
 *				header file.
 *
 ****************************************************************************/

#ifndef USB_EMU_H
#define USB_EMU_H


// application database, preference, ..., creator ID
#define usbEmuCreatorId							'ASem'

// The feature number of the feature under usbEmuCreatorId in which the UInt16 
// port ID of the USB HID connection port is stored (this value is returned by 
// SrmOpen). If this feature exists, it contains the port ID and the HID
// connection to the host is considered open/valid. If this feature does NOT
// exist, their is currently not a HID connection to the host.
#define usbEmuAsUSBPortIdFtr					(1)

// The feature number of the feature under the usbEmuCreatorId whoes existance
// indicates that a USB cable is plugged into the Dana. If this feature does
// NOT exist, there is not a cable plugged into the Dana. The feature currently
// does not contain any meaningful value. 
#define usbEmuAsUSBCableConnectedFtr			(2)

// sub-launch command codes (sysAppLaunchCmdCustomBase = 0x8000 in SystemMgr.h)
#define appSubLaunchCmdTextTransfer				(sysAppLaunchCmdCustomBase + 0)
#define appSubLaunchCmdEmulator					(sysAppLaunchCmdCustomBase + 1)
#define appSubLaunchCmdFirstUnused				(sysAppLaunchCmdCustomBase + 2)

// EventType.eType field value for events generated by USBEmu
#define asUSBHidConnectedEvent					(AlphaSmartfirstOEMEvent + 1)
#define asUSBHidDisconnectedEvent				(AlphaSmartfirstOEMEvent + 2)

#endif
